package ru.yandex.direct.core.entity.freelancer.service.utils;

import java.time.LocalDateTime;
import java.util.Objects;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCertificate;

/**
 * Вспомогательный класс, в котором дополнительно хранится имя и фамилия, на которую выдан сертификат.
 * Используется только для проверки на принадлежность сертификата фрилансером.
 * (Это поле не в {@link FreelancerCertificate}, так как сертификат хранится в БД
 * в таблице фрилансеров, где имя и фамилия и так уже есть.)
 */
public class FreelancerCertificateWithNames {
    private FreelancerCertificate freelancerCertificate;
    private String firstName;
    private String secondName;
    private LocalDateTime confirmedDate;

    public FreelancerCertificate getFreelancerCertificate() {
        return freelancerCertificate;
    }

    public FreelancerCertificateWithNames withFreelancerCertificate(FreelancerCertificate freelancerCertificate) {
        this.freelancerCertificate = freelancerCertificate;
        return this;
    }

    public String getSecondName() {
        return secondName;
    }

    public FreelancerCertificateWithNames withSecondName(String secondName) {
        this.secondName = secondName;
        return this;
    }

    public String getFirstName() {
        return firstName;
    }

    public FreelancerCertificateWithNames withFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public LocalDateTime getConfirmedDate() {
        return confirmedDate;
    }

    public FreelancerCertificateWithNames withConfirmedDate(LocalDateTime confirmedDate) {
        this.confirmedDate = confirmedDate;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FreelancerCertificateWithNames that = (FreelancerCertificateWithNames) o;
        return Objects.equals(freelancerCertificate, that.freelancerCertificate) &&
                Objects.equals(firstName, that.firstName) &&
                Objects.equals(secondName, that.secondName) &&
                Objects.equals(confirmedDate, that.confirmedDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(freelancerCertificate, firstName, secondName, confirmedDate);
    }

}
