package ru.yandex.direct.core.entity.freelancer.service.utils;

import java.nio.file.Paths;

public class UgcDbConnectionUtils {

    private static final String MAIN_TABLE = "direct-service";
    private static final String FEEDBACK_TABLE = "reviews";
    private static final String YQL_FILTER = "?yql_filter=";
    private static final String ORDER_BY = "ORDER+BY+";
    private static final String CREATE_TIME = "$.CreateTime/seconds";
    private static final String DESC_ORDER = "+DESC";

    public static String createPathToUgc(String feedbackId, Long freelancerId) {
        return Paths.get(MAIN_TABLE, String.valueOf(freelancerId), FEEDBACK_TABLE, feedbackId).toString();
    }

    public static String createPathToUgc(Long freelancerId) {
        return Paths.get(MAIN_TABLE, String.valueOf(freelancerId) + sortedByCreateTime()).toString();
    }

    private static String sortedByCreateTime() {
        StringBuilder builder = new StringBuilder(YQL_FILTER)
                .append(ORDER_BY)
                .append(CREATE_TIME)
                .append(DESC_ORDER);
        return builder.toString();
    }
}
