package ru.yandex.direct.core.entity.freelancer.service.validation;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

import static ru.yandex.direct.core.entity.freelancer.service.validation.AvatarsDefects.AvatarsClientDefects.SERVER_CONNECTION_ERROR;
import static ru.yandex.direct.core.entity.freelancer.service.validation.AvatarsDefects.AvatarsClientDefects.UNKNOWN_ERROR;

public class AvatarsDefects {
    public enum AvatarsClientDefects implements DefectId<Void> {
        SERVER_CONNECTION_ERROR,
        UNKNOWN_ERROR
    }

    public static Defect serverConnectionProblem() {
        return new Defect<>(SERVER_CONNECTION_ERROR);
    }

    public static Defect unknownError() {
        return new Defect<>(UNKNOWN_ERROR);
    }
}
