package ru.yandex.direct.core.entity.freelancer.service.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCardModeration;
import ru.yandex.direct.core.entity.freelancer.model.FreelancersCardStatusModerate;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.freelancer.model.FreelancersCardStatusModerate.ACCEPTED;
import static ru.yandex.direct.core.entity.freelancer.model.FreelancersCardStatusModerate.DECLINED;
import static ru.yandex.direct.validation.builder.When.isTrue;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.isEmptyCollection;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection;
import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class CardModerationResultValidator implements Validator<FreelancerCardModeration, Defect> {

    private static final Set<FreelancersCardStatusModerate> ACCEPTED_STATUSES =
            new HashSet<>(Arrays.asList(ACCEPTED, DECLINED));

    @Override
    public ValidationResult<FreelancerCardModeration, Defect> apply(
            FreelancerCardModeration moderationResult) {
        ModelItemValidationBuilder<FreelancerCardModeration> vb =
                ModelItemValidationBuilder.of(moderationResult);
        vb.item(FreelancerCardModeration.ID)
                .check(notNull());
        vb.item(FreelancerCardModeration.FREELANCER_ID)
                .check(notNull());
        vb.item(FreelancerCardModeration.STATUS_MODERATE)
                .check(notNull())
                .check(inSet(ACCEPTED_STATUSES));
        vb.item(FreelancerCardModeration.DECLINE_REASON)
                .check(notNull())
                .check(isEmptyCollection(), isTrue(ACCEPTED.equals(moderationResult.getStatusModerate())))
                .check(notEmptyCollection(), isTrue(DECLINED.equals(moderationResult.getStatusModerate())));
        return vb.getResult();
    }
}
