package ru.yandex.direct.core.entity.freelancer.service.validation;

import java.math.BigDecimal;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerBase;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerCertificate;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;

@Component
public class FreelancerBaseValidator implements Validator<FreelancerBase, Defect> {

    @Override
    public ValidationResult<FreelancerBase, Defect> apply(FreelancerBase freelancer) {
        ModelItemValidationBuilder<FreelancerBase> vb = ModelItemValidationBuilder.of(freelancer);
        vb.item(freelancer == null ? null : BigDecimal.valueOf(freelancer.getRating()), FreelancerBase.RATING.name())
                .check(inRange(BigDecimal.ZERO, BigDecimal.valueOf(5)));

        vb.item(FreelancerBase.STATUS)
                .check(notNull());
        vb.item(FreelancerBase.IS_SEARCHABLE)
                .check(notNull());
        vb.list(FreelancerBase.CERTIFICATES)
                .check(notNull())
                .checkEachBy(certificateValidator());

        return vb.getResult();
    }

    private Validator<FreelancerCertificate, Defect> certificateValidator() {
        return certificate -> {
            ModelItemValidationBuilder<FreelancerCertificate> vb = ModelItemValidationBuilder.of(certificate);
            vb.item(FreelancerCertificate.CERT_ID)
                    .check(notNull());
            vb.item(FreelancerCertificate.TYPE)
                    .check(notNull());
            return vb.getResult();
        };
    }
}
