package ru.yandex.direct.core.entity.freelancer.service.validation;

import java.util.List;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerCardModeration;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;
import static ru.yandex.direct.validation.defect.CommonDefects.objectNotFound;

@Service
public class FreelancerCardValidationService {

    private final FreelancerCardValidator cardValidator;
    private final CardModerationResultValidator moderationResultValidator;

    public FreelancerCardValidationService(
            FreelancerCardValidator cardValidator,
            CardModerationResultValidator moderationResultValidator) {
        this.cardValidator = cardValidator;
        this.moderationResultValidator = moderationResultValidator;
    }

    public ValidationResult<List<FreelancerCard>, Defect> validate(List<FreelancerCard> addingFreelancerCards) {
        ListValidationBuilder<FreelancerCard, Defect> lvb = ListValidationBuilder.of(addingFreelancerCards);
        lvb.checkEachBy(cardValidator, When.isValid());
        return lvb.getResult();
    }

    public ValidationResult<List<FreelancerCardModeration>, Defect> validateCardModerations(
            List<FreelancerCardModeration> applyingModerations,
            List<FreelancerCard> moderatedFreelancerCards) {
        Set<Long> existingCardIds = StreamEx.of(moderatedFreelancerCards)
                .map(FreelancerCard::getId)
                .toSet();
        ListValidationBuilder<FreelancerCardModeration, Defect> lvb =
                ListValidationBuilder.of(applyingModerations);
        lvb.checkEachBy(cardIdValidator(existingCardIds))
                .checkEachBy(moderationResultValidator);
        return lvb.getResult();
    }

    private Validator<FreelancerCardModeration, Defect> cardIdValidator(Set<Long> existingCardIds) {
        return cardModeration -> {
            ModelItemValidationBuilder<FreelancerCardModeration> vb = ModelItemValidationBuilder.of(cardModeration);
            vb.item(FreelancerCardModeration.ID)
                    .check(inSet(existingCardIds), objectNotFound());
            return vb.getResult();
        };
    }
}
