package ru.yandex.direct.core.entity.freelancer.service.validation;

import java.util.List;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerFeedback;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerProjectStatus;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectId;

public class FreelancerDefects {

    public enum VoidDefects implements DefectId<Void> {
        PROJECT_NOT_FOUND,
        CLIENT_NOT_FOUND,
        MUST_BE_CLIENT,
        MUST_HAVE_FREELANCER_CARD,
        MUST_BE_FREELANCER,
        CLIENT_IS_ALREADY_FREELANCER,
        CLIENT_HAS_WRONG_ROLE,
        // Такой скил отсутствует в ppcdict.
        SKILL_DOES_NOT_EXIST,
        CLIENT_CURRENCY_IS_NOT_CONVERTED,
        AGENCY_CLIENT_CANT_REQUEST_SERVICE,
        SOCIAL_CLIENTS_CANT_REQUEST_SERVICE,
        USERS_COUNT_EXCEEDED,
        DIRECT_CERTIFICATE_NOT_FOUND,
        NAMES_MUST_BE_SAME_AS_CERT_NAMES
    }

    public enum ProjectsDefects implements DefectId<List<Long>> {
        PROJECTS_ARE_ALREADY_EXIST
    }

    public enum StatusDefects implements DefectId<FreelancerProjectStatus> {
        TRANSITION_IS_NOT_AVAILABLE
    }

    public enum FeedbackDefects implements DefectId<FreelancerFeedback> {
        OPERATOR_HAS_NO_PROJECT_WITH_FREELANCER,
        OPERATOR_IS_NOT_CHIEF,
        OPERATOR_HAS_WRONG_ROLE,
        INCORRECT_FEEDBACK_TEXT_SIZE,
        FEEDBACK_NOT_FOUND,
        FEEDBACK_ALREADY_EXIST
    }

    public static Defect<FreelancerProjectStatus> transitionIsNotAvailable(
            FreelancerProjectStatus oldStatus) {
        return new Defect<>(StatusDefects.TRANSITION_IS_NOT_AVAILABLE, oldStatus);
    }

    public static Defect<FreelancerFeedback> operatorHasNoProjectWithFreelancer() {
        return new Defect<>(FeedbackDefects.OPERATOR_HAS_NO_PROJECT_WITH_FREELANCER);
    }

    public static Defect<FreelancerFeedback> operatorIsNotChief() {
        return new Defect<>(FeedbackDefects.OPERATOR_IS_NOT_CHIEF);
    }

    public static Defect<FreelancerFeedback> operatorHasWrongRole() {
        return new Defect<>(FeedbackDefects.OPERATOR_HAS_WRONG_ROLE);
    }

    public static Defect<FreelancerFeedback> feedbackNotFound() {
        return new Defect<>(FeedbackDefects.FEEDBACK_NOT_FOUND);
    }

    public static Defect<FreelancerFeedback> incorrectFeedbackTextSize() {
        return new Defect<>(FeedbackDefects.INCORRECT_FEEDBACK_TEXT_SIZE);
    }

    public static Defect<FreelancerFeedback> feedbackAlreadyExist() {
        return new Defect<>(FeedbackDefects.FEEDBACK_ALREADY_EXIST);
    }

    public static Defect<Void> projectNotFound() {
        return new Defect<>(VoidDefects.PROJECT_NOT_FOUND);
    }

    public static Defect<Void> skillDoesNotExist() {
        return new Defect<>(VoidDefects.SKILL_DOES_NOT_EXIST);
    }

    public static Defect<List<Long>> projectsAreAlreadyExist(List<Long> existingProjectIds) {
        return new Defect<>(ProjectsDefects.PROJECTS_ARE_ALREADY_EXIST, existingProjectIds);
    }

    public static Defect<Void> clientNotFound() {
        return new Defect<>(VoidDefects.CLIENT_NOT_FOUND);
    }

    public static Defect<Void> mustBeClient() {
        return new Defect<>(VoidDefects.MUST_BE_CLIENT);
    }

    public static Defect<Void> mustBeFreelancer() {
        return new Defect<>(VoidDefects.MUST_BE_FREELANCER);
    }

    public static Defect<Void> mustHaveFreelancerCard() {
        return new Defect<>(VoidDefects.MUST_HAVE_FREELANCER_CARD);
    }

    public static Defect<Void> clientIsAlreadyFreelancer() {
        return new Defect<>(VoidDefects.CLIENT_IS_ALREADY_FREELANCER);
    }

    public static Defect<Void> clientHasWrongRole() {
        return new Defect<>(VoidDefects.CLIENT_HAS_WRONG_ROLE);
    }

    public static Defect<Void> clientCurrencyIsNotConverted() {
        return new Defect<>(VoidDefects.CLIENT_CURRENCY_IS_NOT_CONVERTED);
    }

    public static Defect<Void> agencyClientCantRequestService() {
        return new Defect<>(VoidDefects.AGENCY_CLIENT_CANT_REQUEST_SERVICE);
    }

    public static Defect<Void> socialClientsCantRequestService() {
        return new Defect<>(VoidDefects.AGENCY_CLIENT_CANT_REQUEST_SERVICE);
    }

    public static Defect<Void> usersCountExceeded() {
        return new Defect<>(VoidDefects.USERS_COUNT_EXCEEDED);
    }

    public static Defect<Void> directCertificateNotFound() {
        return new Defect<>(VoidDefects.DIRECT_CERTIFICATE_NOT_FOUND);
    }

    public static Defect<Void> namesMustBeSameAsCertNames() {
        return new Defect<>(VoidDefects.NAMES_MUST_BE_SAME_AS_CERT_NAMES);
    }
}
