package ru.yandex.direct.core.entity.freelancer.service.validation;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.freelancer.model.FreelancerFeedback;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects.incorrectFeedbackTextSize;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.minStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@Component
public class FreelancerFeedbackValidator implements Validator<FreelancerFeedback, Defect> {

    private static final int MIN_FEEDBACK_TEXT_LENGTH = 3;
    private static final int MAX_FEEDBACK_TEXT_LENGTH = 10000;

    @Override
    public ValidationResult<FreelancerFeedback, Defect> apply(FreelancerFeedback feedback) {
        ModelItemValidationBuilder<FreelancerFeedback> vb = ModelItemValidationBuilder.of(feedback);

        vb.item(FreelancerFeedback.FEEDBACK_ID)
                .check(notNull());
        vb.item(FreelancerFeedback.AUTHOR_UID)
                .check(notNull());
        vb.item(FreelancerFeedback.FREELANCER_ID)
                .check(notNull());
        vb.item(FreelancerFeedback.CREATED_TIME)
                .check(notNull());
        vb.item(FreelancerFeedback.OVERALL_MARK)
                .check(notNull());
        vb.item(FreelancerFeedback.WILL_RECOMMEND)
                .check(notNull());
        vb.item(FreelancerFeedback.SKILLS)
                .check(notNull());
        vb.item(FreelancerFeedback.FEEDBACK_TEXT)
                .check(notNull())
                .check(notBlank(), When.isValid())
                .check(minStringLength(MIN_FEEDBACK_TEXT_LENGTH), incorrectFeedbackTextSize(), When.isValid())
                .check(maxStringLength(MAX_FEEDBACK_TEXT_LENGTH), incorrectFeedbackTextSize(), When.isValid());

        return vb.getResult();
    }
}
