package ru.yandex.direct.core.entity.freelancer.utils;

import java.util.Collection;
import java.util.List;

import ru.yandex.direct.core.entity.freelancer.model.ClientAvatar;
import ru.yandex.direct.core.entity.freelancer.model.ClientAvatarId;
import ru.yandex.direct.core.entity.freelancer.model.FreelancerCard;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Набор фабричных методов для {@link ClientAvatarId}
 */
public class ClientAvatarIdUtils {
    public static ClientAvatar clientAvatarIdFromParams(Long clientId, Long avatarId) {
        return new ClientAvatar()
                .withId(avatarId)
                .withClientId(clientId);
    }

    public static ClientAvatarId clientAvatarIdFromCard(FreelancerCard card) {
        return clientAvatarIdFromParams(card.getFreelancerId(), card.getAvatarId());
    }

    public static List<ClientAvatarId> clientAvatarIdFromCards(Collection<FreelancerCard> cards) {
        return mapList(cards, ClientAvatarIdUtils::clientAvatarIdFromCard);
    }
}
