package ru.yandex.direct.core.entity.geo.repository;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.geo.model.GeoRegion;
import ru.yandex.direct.core.entity.geo.model.GeoRegionType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppcdict.tables.GeoRegions.GEO_REGIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
@ParametersAreNonnullByDefault
public class GeoRegionRepository implements IGeoRegionRepository {
    private final DslContextProvider dslContextProvider;
    private JooqMapperWithSupplier<GeoRegion> mapper;

    public GeoRegionRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;

        mapper = createMapper();
    }

    public Collection<GeoRegion> getGeoRegionsByIds(Collection<Long> ids) {
        return dslContextProvider
                .ppcdict()
                .select(mapper.getFieldsToRead())
                .from(GEO_REGIONS)
                .where(GEO_REGIONS.REGION_ID.in(ids))
                .fetch()
                .map(mapper::fromDb);
    }

    private JooqMapperWithSupplier<GeoRegion> createMapper() {
        return JooqMapperWithSupplierBuilder
                .builder(GeoRegion::new)
                .map(property(GeoRegion.ID, GEO_REGIONS.REGION_ID))
                .map(property(GeoRegion.ENAME, GEO_REGIONS.ENAME))
                .map(property(GeoRegion.NAME, GEO_REGIONS.NAME))
                .map(property(GeoRegion.OFFICE_ID, GEO_REGIONS.OFFICE_ID))
                .map(property(GeoRegion.PARENT_ID, GEO_REGIONS.PARENT_ID))
                .map(property(GeoRegion.TRNAME, GEO_REGIONS.TR_NAME))
                .map(
                        convertibleProperty(
                                GeoRegion.TYPE, GEO_REGIONS.TYPE,
                                GeoRegionType::fromTypedValue,
                                GeoRegionType::getTypedValue
                        )
                )
                .map(property(GeoRegion.UANAME, GEO_REGIONS.UA_NAME))
                .build();
    }
}
