package ru.yandex.direct.core.entity.goal.repository

import one.util.streamex.StreamEx
import org.springframework.stereotype.Repository
import ru.yandex.direct.grid.schema.yt.Tables
import ru.yandex.direct.metrika.client.model.response.CounterInfoDirect
import ru.yandex.direct.ytcomponents.service.MetrikaCountersDynContextProvider
import ru.yandex.direct.ytwrapper.YtTableUtils
import ru.yandex.direct.ytwrapper.dynamic.dsl.YtDSL
import javax.annotation.ParametersAreNonnullByDefault

@Repository
@ParametersAreNonnullByDefault
class MetrikaCountersRepository(
    private val dynContextProvider: MetrikaCountersDynContextProvider,
) {
    companion object {
        private val COUNTERS = Tables.CONV_MAIN_COUNTERS.`as`("C")
        private val COUNTER_ID = YtTableUtils.aliased(COUNTERS.COUNTER_ID)
        private val COUNTER_NAME = YtTableUtils.aliased(COUNTERS.NAME)
        private val SITE_PATH = YtTableUtils.aliased(COUNTERS.SITE_PATH)
    }

    fun getCountersByIds(counterIds: Collection<Int>): Map<Int, CounterInfoDirect> {
        val query = YtDSL.ytContext()
            .select(COUNTER_ID, COUNTER_NAME, SITE_PATH)
            .from(COUNTERS)
            .where(COUNTER_ID.`in`(counterIds))

        val rows = dynContextProvider.context
            .executeSelect(query)
            .yTreeRows

        return StreamEx.of(rows)
            .mapToEntry(
                { it.getLong(COUNTER_ID.name).toInt() },
                {
                    CounterInfoDirect().withId(it.getLong(COUNTER_ID.name).toInt())
                        .withName(it.getStringO(COUNTER_NAME.name).orElse(null))
                        .withSitePath(it.getStringO(SITE_PATH.name).orElse(null))
                }
            ).toMap()
    }

}
