package ru.yandex.direct.core.entity.grants.model;

import java.util.function.BiConsumer;
import java.util.function.Function;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

public final class Grants implements ModelWithId {
    public static final ModelProperty<Grants, Long> CLIENT_ID =
            prop("clientId", Grants::getClientId, Grants::setClientId);
    public static final ModelProperty<Grants, Boolean> ALLOW_EDIT_CAMPAIGN =
            prop("allowEditCampaigns", Grants::getAllowEditCampaigns, Grants::setAllowEditCampaigns);
    public static final ModelProperty<Grants, Boolean> ALLOW_IMPORT_XLS =
            prop("allowImportXls", Grants::getAllowImportXls, Grants::setAllowImportXls);
    public static final ModelProperty<Grants, Boolean> ALLOW_TRANSFER_MONEY =
            prop("allowTransferMoney", Grants::getAllowTransferMoney, Grants::setAllowTransferMoney);

    private Long clientId;
    private Boolean allowEditCampaigns;
    private Boolean allowImportXls;
    private Boolean allowTransferMoney;

    public Grants() {
    }

    public Grants(Long clientId, boolean allowEditCampaigns, boolean allowImportXls, boolean allowTransferMoney) {
        this.clientId = clientId;
        this.allowEditCampaigns = allowEditCampaigns;
        this.allowImportXls = allowImportXls;
        this.allowTransferMoney = allowTransferMoney;
    }

    private static <V> ModelProperty<Grants, V> prop(
            String name, Function<Grants, V> getter, BiConsumer<Grants, V> setter) {
        return ModelProperty.create(Grants.class, name, getter, setter);
    }

    @Override
    public Long getId() {
        return clientId;
    }

    @Override
    public void setId(Long id) {
        this.clientId = id;
    }

    public Grants withId(final Long id) {
        this.clientId = id;
        return this;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }

    public Long getClientId() {
        return clientId;
    }

    public void setClientId(Long clientId) {
        this.clientId = clientId;
    }

    public Boolean getAllowEditCampaigns() {
        return allowEditCampaigns;
    }

    public void setAllowEditCampaigns(Boolean allowEditCampaigns) {
        this.allowEditCampaigns = allowEditCampaigns;
    }

    public Boolean getAllowImportXls() {
        return allowImportXls;
    }

    public void setAllowImportXls(Boolean allowImportXls) {
        this.allowImportXls = allowImportXls;
    }

    public Boolean getAllowTransferMoney() {
        return allowTransferMoney;
    }

    public void setAllowTransferMoney(Boolean allowTransferMoney) {
        this.allowTransferMoney = allowTransferMoney;
    }

    public Grants withClientId(final Long clientId) {
        setClientId(clientId);
        return this;
    }

    public Grants withAllowEditCampaigns(final Boolean allowEditCampaigns) {
        setAllowEditCampaigns(allowEditCampaigns);
        return this;
    }

    public Grants withAllowImportXls(final Boolean allowImportXls) {
        setAllowImportXls(allowImportXls);
        return this;
    }

    public Grants withAllowTransferMoney(final Boolean allowTransferMoney) {
        setAllowTransferMoney(allowTransferMoney);
        return this;
    }
}
