package ru.yandex.direct.core.entity.grants.service;

import java.util.Collection;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.grants.model.Grants;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.rbac.RbacService;
import ru.yandex.direct.rbac.model.SubclientGrants;

@Service
@ParametersAreNonnullByDefault
public class GrantsService {
    private final RbacService rbacService;

    @Autowired
    public GrantsService(RbacService rbacService) {
        this.rbacService = rbacService;
    }

    /**
     * Получение Grants субклиентов агентства по clientIds
     *
     * @param agencyId  это clientId агентства
     * @param clientIds субклиентов
     */
    public Collection<Grants> massGet(ClientId agencyId, Collection<ClientId> clientIds) {
        long agencyUid = rbacService.getChiefByClientId(agencyId);
        Collection<SubclientGrants> subclientsGrants = rbacService.getSubclientsGrants(agencyUid, clientIds);
        return subclientsGrants.stream().map(subclientGrants ->
                new Grants(subclientGrants.getClientId().asLong(),
                        subclientGrants.canCreateCampaign(),
                        subclientGrants.canImportXLS(),
                        subclientGrants.canToTransferMoney())).collect(Collectors.toList());
    }
}
