package ru.yandex.direct.core.entity.grants.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.client.repository.ClientRepository;
import ru.yandex.direct.core.entity.grants.model.Grants;
import ru.yandex.direct.core.entity.grants.service.validation.GrantsValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.rbac.RbacService;

@Component
public class GrantsUpdateOperationProvider {

    private final GrantsService grantsService;
    private final GrantsValidationService grantsValidationService;
    private final RbacService rbacService;
    private final ClientRepository clientRepository;
    private final ShardHelper shardHelper;

    @Autowired
    public GrantsUpdateOperationProvider(GrantsService grantsService,
                                         GrantsValidationService grantsValidationService,
                                         RbacService rbacService, ClientRepository clientRepository,
                                         ShardHelper shardHelper) {
        this.grantsService = grantsService;
        this.grantsValidationService = grantsValidationService;
        this.rbacService = rbacService;
        this.clientRepository = clientRepository;
        this.shardHelper = shardHelper;
    }

    public GrantsUpdateOperation get(List<ModelChanges<Grants>> modelChanges, long operatorUid, ClientId agencyId) {
        return new GrantsUpdateOperation(Applicability.PARTIAL, grantsService, grantsValidationService, modelChanges,
                rbacService, shardHelper, clientRepository, operatorUid, agencyId);
    }
}
