package ru.yandex.direct.core.entity.grants.service.validation;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.grants.model.Grants;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.grants.service.validation.GrantsDefectDefinitions.inconsistentStateAllowEditCampaignAndAllowImportXls;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@Service
public class GrantsValidationService {
    public ValidationResult<Grants, Defect> validate(Grants grants) {
        ModelItemValidationBuilder<Grants> vb = ModelItemValidationBuilder.of(grants);
        vb.item(Grants.CLIENT_ID)
                .check(notNull())
                .check(validId());
        vb.item(Grants.ALLOW_EDIT_CAMPAIGN)
                .check(notNull());
        vb.item(Grants.ALLOW_IMPORT_XLS)
                .check(notNull());
        vb.item(Grants.ALLOW_TRANSFER_MONEY)
                .check(notNull());
        if (grants.getAllowEditCampaigns() != null && !grants.getAllowEditCampaigns()) {
            vb.item(Grants.ALLOW_IMPORT_XLS)
                    .check(Constraint.fromPredicate(
                            x -> !x, inconsistentStateAllowEditCampaignAndAllowImportXls()), When.notNull());
        }
        return vb.getResult();
    }
}
