package ru.yandex.direct.core.entity.hrefparams.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.constraint.StringConstraints;
import ru.yandex.direct.validation.result.Defect;

import static ru.yandex.direct.core.entity.hrefparams.validation.HrefParamsConstants.DEFAULT_URL_FOR_VALIDATION;
import static ru.yandex.direct.core.entity.hrefparams.validation.HrefParamsConstants.HREF_PARAMETERS_MAX_LENGTH;
import static ru.yandex.direct.core.entity.hrefparams.validation.defects.HrefParamsDefects.hrefParamsTooLong;
import static ru.yandex.direct.core.entity.hrefparams.validation.defects.HrefParamsDefects.hrefWithParamsInvalid;

@ParametersAreNonnullByDefault
public class HrefParamsConstraints {

    private HrefParamsConstraints() {
    }

    public static Constraint<String, Defect> hrefParamsHaveValidLength() {
        return Constraint.fromPredicate(params -> params.length() <= HREF_PARAMETERS_MAX_LENGTH,
                hrefParamsTooLong());
    }

    public static Constraint<String, Defect> hrefWithParamsValid() {
        return Constraint.fromPredicate(params -> StringConstraints.isValidHref(hrefWithParams(params)),
                hrefWithParamsInvalid());
    }

    private static String hrefWithParams(String params) {
        return DEFAULT_URL_FOR_VALIDATION + "?" + params;
    }

}
