package ru.yandex.direct.core.entity.hypergeo.operation;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSegment;
import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSimple;
import ru.yandex.direct.core.entity.hypergeo.repository.HyperGeoSegmentRepository;
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoSegmentValidationService;
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoValidationService;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;

@Service
@ParametersAreNonnullByDefault
public class HyperGeoOperationsFactory {
    private final HyperGeoValidationService hyperGeoValidationService;
    private final HyperGeoSegmentValidationService hyperGeoSegmentValidationService;
    private final HyperGeoSegmentRepository hyperGeoSegmentRepository;
    private final HyperGeoOperationsHelper hyperGeoOperationsHelper;
    private final RetargetingConditionRepository retargetingConditionRepository;

    @Autowired
    public HyperGeoOperationsFactory(HyperGeoValidationService hyperGeoValidationService,
                                     HyperGeoSegmentValidationService hyperGeoSegmentValidationService,
                                     HyperGeoSegmentRepository hyperGeoSegmentRepository,
                                     HyperGeoOperationsHelper hyperGeoOperationsHelper,
                                     RetargetingConditionRepository retargetingConditionRepository) {
        this.hyperGeoValidationService = hyperGeoValidationService;
        this.hyperGeoSegmentValidationService = hyperGeoSegmentValidationService;
        this.hyperGeoSegmentRepository = hyperGeoSegmentRepository;
        this.hyperGeoOperationsHelper = hyperGeoOperationsHelper;
        this.retargetingConditionRepository = retargetingConditionRepository;
    }

    public HyperGeoSegmentsAddOperation createHyperGeoSegmentsAddOperation(Applicability applicability,
                                                                           List<HyperGeoSegment> models, int shard,
                                                                           String login) {
        return new HyperGeoSegmentsAddOperation(applicability, models, hyperGeoSegmentValidationService,
                hyperGeoSegmentRepository, hyperGeoOperationsHelper, shard, login);
    }

    public HyperGeoSegmentsDeleteOperation createHyperGeoSegmentsDeleteOperation(Applicability applicability,
                                                                                 List<Long> hyperGeoSegmentIds,
                                                                                 int shard) {
        return new HyperGeoSegmentsDeleteOperation(applicability, hyperGeoSegmentIds, shard,
                hyperGeoSegmentValidationService, hyperGeoSegmentRepository, hyperGeoOperationsHelper);
    }

    public HyperGeosAddOperation createHyperGeosAddOperation(Applicability applicability,
                                                             List<HyperGeoSimple> models, int shard,
                                                             ClientId clientId) {
        return new HyperGeosAddOperation(applicability, models, retargetingConditionRepository,
                hyperGeoValidationService, shard, clientId);
    }

    public HyperGeosDeleteOperation createHyperGeosDeleteOperation(Applicability applicability,
                                                                   List<Long> hyperGeoIds,
                                                                   DSLContext context, @Nullable ClientId clientId) {
        return new HyperGeosDeleteOperation(applicability, hyperGeoIds, context, clientId, hyperGeoValidationService,
                retargetingConditionRepository, hyperGeoSegmentRepository, hyperGeoOperationsHelper);
    }
}
