package ru.yandex.direct.core.entity.hypergeo.operation;

import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSegment;
import ru.yandex.direct.core.entity.hypergeo.repository.HyperGeoSegmentRepository;
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoSegmentValidationService;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.AbstractAddOperation;
import ru.yandex.direct.operation.add.ModelsValidatedStep;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class HyperGeoSegmentsAddOperation extends AbstractAddOperation<HyperGeoSegment, Long> {

    private final HyperGeoSegmentValidationService hyperGeoSegmentValidationService;
    private final HyperGeoSegmentRepository hyperGeoSegmentRepository;
    private final HyperGeoOperationsHelper helper;

    private final int shard;
    private final String login;

    public HyperGeoSegmentsAddOperation(Applicability applicability, List<HyperGeoSegment> models,
                                        HyperGeoSegmentValidationService hyperGeoSegmentValidationService,
                                        HyperGeoSegmentRepository hyperGeoSegmentRepository,
                                        HyperGeoOperationsHelper helper,
                                        int shard, String login) {
        super(applicability, models);

        this.hyperGeoSegmentValidationService = hyperGeoSegmentValidationService;
        this.hyperGeoSegmentRepository = hyperGeoSegmentRepository;
        this.helper = helper;

        this.shard = shard;
        this.login = login;
    }

    @Override
    protected void validate(ValidationResult<List<HyperGeoSegment>, Defect> preValidationResult) {
        new ListValidationBuilder<>(preValidationResult)
                .checkBy(hyperGeoSegmentValidationService::validateHyperGeoSegments);
    }

    @Override
    protected void onModelsValidated(ModelsValidatedStep<HyperGeoSegment> modelsValidatedStep) {
        var models = modelsValidatedStep.getModels();
        helper.createGeoSegments(models, login);
        helper.fillCoveringGeo(models);
    }

    @Override
    protected Map<Integer, Long> execute(Map<Integer, HyperGeoSegment> validModelsMapToApply) {
        hyperGeoSegmentRepository.addHyperGeoSegments(shard, validModelsMapToApply.values());

        return EntryStream.of(validModelsMapToApply)
                .mapValues(HyperGeoSegment::getId)
                .toMap();
    }
}
