package ru.yandex.direct.core.entity.hypergeo.operation

import ru.yandex.direct.core.entity.hypergeo.repository.HyperGeoSegmentRepository
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoSegmentValidationService
import ru.yandex.direct.operation.Applicability
import ru.yandex.direct.operation.operationwithid.AbstractOperationWithId
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class HyperGeoSegmentsDeleteOperation(
    applicability: Applicability,
    modelIds: List<Long>,
    private val shard: Int,
    private val hyperGeoSegmentValidationService: HyperGeoSegmentValidationService,
    private val hyperGeoSegmentRepository: HyperGeoSegmentRepository,
    private val hyperGeoOperationsHelper: HyperGeoOperationsHelper,
) : AbstractOperationWithId(applicability, modelIds) {
    override fun validate(ids: List<Long>): ValidationResult<List<Long>, Defect<Any>> {
        return hyperGeoSegmentValidationService.validateDelete(shard, ids)
    }

    override fun execute(validIds: List<Long>) {
        if (validIds.isEmpty()) {
            return
        }

        // удаляем сегменты в Я.Аудиториях
        val deletedIds = hyperGeoOperationsHelper.deleteGeoSegments(validIds)

        // удаляем записи в hypergeo_segments о тех сегментах, которые получилось удалить в Я.Аудиториях
        hyperGeoSegmentRepository.deleteHyperGeoSegmentById(shard, deletedIds)
    }
}
