package ru.yandex.direct.core.entity.hypergeo.operation;

import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSimple;
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoValidationService;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.add.AbstractAddOperation;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.util.HyperGeoUtils.convertToRetargetingCondition;

public class HyperGeosAddOperation extends AbstractAddOperation<HyperGeoSimple, Long> {

    private final RetargetingConditionRepository retargetingConditionRepository;
    private final HyperGeoValidationService hyperGeoValidationService;

    private final int shard;
    private final ClientId clientId;

    public HyperGeosAddOperation(Applicability applicability, List<HyperGeoSimple> models,
                                 RetargetingConditionRepository retargetingConditionRepository,
                                 HyperGeoValidationService hyperGeoValidationService,
                                 int shard, ClientId clientId) {
        super(applicability, models);

        this.retargetingConditionRepository = retargetingConditionRepository;
        this.hyperGeoValidationService = hyperGeoValidationService;

        this.shard = shard;
        this.clientId = clientId;
    }

    @Override
    protected ValidationResult<List<HyperGeoSimple>, Defect> preValidate(List<HyperGeoSimple> models) {
        return hyperGeoValidationService.preValidateHyperGeos(models);
    }

    @Override
    protected void validate(ValidationResult<List<HyperGeoSimple>, Defect> preValidationResult) {
        new ListValidationBuilder<>(preValidationResult)
                .checkBy(hyperGeos -> hyperGeoValidationService.validateHyperGeos(shard, clientId, hyperGeos));
    }

    @Override
    protected Map<Integer, Long> execute(Map<Integer, HyperGeoSimple> validModelsMapToApply) {
        Map<Integer, RetargetingCondition> hyperGeoRetargetingConditionByIndex = EntryStream.of(validModelsMapToApply)
                .mapValues(hyperGeo -> convertToRetargetingCondition(clientId, hyperGeo))
                .toMap();

        retargetingConditionRepository.add(shard, hyperGeoRetargetingConditionByIndex.values());

        return EntryStream.of(hyperGeoRetargetingConditionByIndex)
                .peekKeyValue((index, hyperGeoRetargetingCondition) -> {
                    Long hyperGeoId = hyperGeoRetargetingCondition.getId();
                    validModelsMapToApply.get(index).setId(hyperGeoId);
                })
                .mapValues(RetargetingCondition::getId)
                .toMap();
    }
}
