package ru.yandex.direct.core.entity.hypergeo.operation

import org.jooq.DSLContext
import ru.yandex.direct.core.entity.hypergeo.repository.HyperGeoSegmentRepository
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoValidationService
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingConditionRepository
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.operation.Applicability
import ru.yandex.direct.operation.operationwithid.AbstractOperationWithId
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class HyperGeosDeleteOperation(
    applicability: Applicability,
    modelIds: List<Long>,
    private val dslContext: DSLContext,
    private val clientId: ClientId?,
    private val hyperGeoValidationService: HyperGeoValidationService,
    private val retargetingConditionRepository: RetargetingConditionRepository,
    private val hyperGeoSegmentRepository: HyperGeoSegmentRepository,
    private val hyperGeoOperationsHelper: HyperGeoOperationsHelper,
) : AbstractOperationWithId(applicability, modelIds) {
    override fun validate(ids: List<Long>): ValidationResult<MutableList<Long>, Defect<Any>> {
        return hyperGeoValidationService.validateDelete(dslContext, clientId, ids)
    }

    override fun execute(validIds: List<Long>) {
        if (validIds.isEmpty()) {
            return
        }

        // достаем записи о сегментах
        val hyperGeoSegmentIds = hyperGeoSegmentRepository
            .getHyperGeoSegmentIdsByHyperGeoId(dslContext, clientId, validIds)

        // удаляем записи о гипер гео и сегментах в retargeting_conditions и retargeting_goals
        retargetingConditionRepository.deleteHyperGeo(dslContext, clientId, validIds)

        // удаляем сегменты в Я.Аудиториях
        val unusedHyperGeoSegmentIds =
            hyperGeoSegmentRepository.getUnusedHyperGeoSegmentIds(dslContext, hyperGeoSegmentIds)
        val deletedSegmentIds = hyperGeoOperationsHelper.deleteGeoSegments(unusedHyperGeoSegmentIds)

        // удаляем записи в hypergeo_segments о тех сегментах, которые получилось удалить в Я.Аудиториях
        hyperGeoSegmentRepository.deleteHyperGeoSegmentById(dslContext, deletedSegmentIds)
    }
}
