package ru.yandex.direct.core.entity.hypergeo.repository;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.direct.core.entity.hypergeo.model.HyperGeoSegmentDetails;

import static ru.yandex.direct.core.entity.hypergeo.model.GeoSegmentType.REGULAR;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.JsonUtils.fromJson;

@ParametersAreNonnullByDefault
public final class HyperGeoSegmentMappings {

    private static final ObjectMapper OBJECT_MAPPER = createObjectMapper();

    private HyperGeoSegmentMappings() {
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(MapperFeature.AUTO_DETECT_CREATORS,
                MapperFeature.AUTO_DETECT_FIELDS,
                MapperFeature.AUTO_DETECT_GETTERS,
                MapperFeature.AUTO_DETECT_IS_GETTERS);
        return mapper;
    }

    public static HyperGeoSegmentDetails geoSegmentDetailsFromJson(String json) {

        // До добавления поддержки мульти-сегментов в json не писался type и по умолчанию ставился REGULAR
        var hyperGeoSegmentDetails = fromJson(json, HyperGeoSegmentDetails.class);
        hyperGeoSegmentDetails.setGeoSegmentType(nvl(hyperGeoSegmentDetails.getGeoSegmentType(), REGULAR));

        return hyperGeoSegmentDetails;
    }

    public static String geoSegmentDetailsToJson(HyperGeoSegmentDetails hyperGeoSegmentDetails) {
        try {
            return OBJECT_MAPPER.writeValueAsString(hyperGeoSegmentDetails);
        } catch (JsonProcessingException e) {
            throw new IllegalArgumentException("can not serialize object to json", e);
        }
    }
}
