package ru.yandex.direct.core.entity.idm.container;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.idm.model.IdmGroupMemberId;
import ru.yandex.direct.multitype.entity.LimitOffset;

/**
 * Контейнер для фильтров, применяемых при отборе главных менеджеров
 */
@ParametersAreNonnullByDefault
public class IdmGroupsMembersQueryFilter {

    /**
     * Предполагается, что экземпляры фильтров создаются статическими методами под конкретные варианты выборок.
     * Это снижает вероятность ошбкок из-за неконсистентного состояния полей.
     */
    private IdmGroupsMembersQueryFilter() {
    }

    private IdmGroupMemberId lastMemberId;
    private LimitOffset limitOffset;

    public static IdmGroupsMembersQueryFilter allIdmGroupsMembersFilter() {
        return new IdmGroupsMembersQueryFilter();
    }

    public static IdmGroupsMembersQueryFilter getNextIdmGroupsMembersPageFilter(@Nullable IdmGroupMemberId lastMemberId,
                                                                                int pageSize) {
        return new IdmGroupsMembersQueryFilter()
                .withLastMemberId(lastMemberId)
                .withLimitOffset(new LimitOffset(pageSize, 0));
    }

    public IdmGroupMemberId getLastMemberId() {
        return lastMemberId;
    }

    private IdmGroupsMembersQueryFilter withLastMemberId(@Nullable IdmGroupMemberId lastClientId) {
        this.lastMemberId = lastClientId;
        return this;
    }

    /**
     * При установке LimitOffset возвращаемые члены групп сортируются сначала по ClientId, потом по idmGroupId.
     */
    public LimitOffset getLimitOffset() {
        return limitOffset;
    }

    private IdmGroupsMembersQueryFilter withLimitOffset(LimitOffset limitOffset) {
        this.limitOffset = limitOffset;
        return this;
    }

}
