package ru.yandex.direct.core.entity.idm.container;

import ru.yandex.direct.core.entity.idm.model.IdmGroupRole;
import ru.yandex.direct.multitype.entity.LimitOffset;

/**
 * Контейнер для фильтров, применяемых при отборе групповых ролей
 */
@SuppressWarnings("WeakerAccess")
public class IdmGroupsRoleQueryFilter {

    public static IdmGroupsRoleQueryFilter getIdmGroupRolesPage(IdmGroupRole lastReturnedRole, int pageSize) {
        return new IdmGroupsRoleQueryFilter()
                .withLastReturnedRole(lastReturnedRole)
                .withLimitOffset(new LimitOffset(pageSize, 0));
    }

    private IdmGroupRole lastReturnedRole;
    private LimitOffset limitOffset;

    public IdmGroupRole getLastReturnedRole() {
        return lastReturnedRole;
    }

    public IdmGroupsRoleQueryFilter withLastReturnedRole(IdmGroupRole lastReturnedRole) {
        this.lastReturnedRole = lastReturnedRole;
        return this;
    }

    public LimitOffset getLimitOffset() {
        return limitOffset;
    }

    /**
     * При установке LimitOffset возвращаемые роли сортируются сначала по SubjectClientId, потом по GroupId.
     */
    public IdmGroupsRoleQueryFilter withLimitOffset(LimitOffset limitOffset) {
        this.limitOffset = limitOffset;
        return this;
    }

}
