package ru.yandex.direct.core.entity.image.model

import java.util.regex.Pattern

data class AvatarsImage(
    val host: String,
    val namespace: String,
    val groupId: Long,
    val hash: String,
    val size: String,
) {
    companion object {
        private val IMAGE_PATTERN = Pattern.compile("https?://(\\S+)/get-(\\S+)/(\\d+)/(\\S+)/(\\S+)")

        fun fromString(url: String): AvatarsImage {
            val matcher = IMAGE_PATTERN.matcher(url)
            if (!matcher.matches()) {
                throw IllegalArgumentException("Invalid avatars url: $url")
            }

            return AvatarsImage(
                host = matcher.group(1),
                namespace = matcher.group(2),
                groupId = matcher.group(3).toLong(),
                hash = matcher.group(4),
                size = matcher.group(5),
            )
        }
    }

    override fun toString(): String {
        return "https://$host/get-$namespace/$groupId/$hash/$size"
    }
}
