package ru.yandex.direct.core.entity.image.repository;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES_UPLOADS;

@Repository
@ParametersAreNonnullByDefault
public class BannerImagesUploadsRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    BannerImagesUploadsRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Возвращает список id у элементов с DATE_ADDED < {@param borderDateTime}
     *
     * @param shard          шард
     * @param borderDateTime граничное время
     */
    public List<Long> getIdsByDateAdded(int shard, LocalDateTime borderDateTime) {
        return dslContextProvider.ppc(shard)
                .select(BANNER_IMAGES_UPLOADS.ID)
                .from(BANNER_IMAGES_UPLOADS)
                .where(BANNER_IMAGES_UPLOADS.DATE_ADDED.lessThan(borderDateTime))
                .fetch(BANNER_IMAGES_UPLOADS.ID);
    }

    /**
     * Очищает таблицу banner_images_uploads по Id {@param ids}
     *
     * @param shard шард
     * @param ids   коллекция id
     * @return количество удаленных строк
     */
    public int deleteByIds(int shard, Collection<Long> ids) {
        return dslContextProvider.ppc(shard)
                .deleteFrom(BANNER_IMAGES_UPLOADS)
                .where(BANNER_IMAGES_UPLOADS.ID.in(ids))
                .execute();
    }
}
