package ru.yandex.direct.core.entity.image.service;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.CopyOperationContainer;
import ru.yandex.direct.core.copyentity.EntityService;
import ru.yandex.direct.core.entity.image.model.BannerImageFormat;
import ru.yandex.direct.core.entity.image.repository.BannerImageFormatRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

@Service
@ParametersAreNonnullByDefault
public class BannerImageFormatService implements EntityService<BannerImageFormat, String> {
    private final ShardHelper shardHelper;
    private final BannerImageFormatRepository repository;

    public BannerImageFormatService(ShardHelper shardHelper, BannerImageFormatRepository repository) {
        this.shardHelper = shardHelper;
        this.repository = repository;
    }

    @Override
    public List<BannerImageFormat> get(ClientId clientId, Long operatorUid, Collection<String> ids) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return List.copyOf(repository.getBannerImageFormats(shard, clientId, ids).values());
    }

    @Override
    public MassResult<BannerImageFormat> add(
            ClientId clientId, Long operatorUid, List<BannerImageFormat> entities, Applicability applicability) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        repository.addBannerImageFormat(shard, entities);
        return MassResult.successfulMassAction(entities, new ValidationResult<>(entities));
    }

    @Override
    public MassResult<BannerImageFormat> copy(CopyOperationContainer copyContainer, List<BannerImageFormat> entities,
                                              Applicability applicability) {
        repository.addBannerImageFormat(copyContainer.getShardTo(), entities);
        return MassResult.successfulMassAction(entities, new ValidationResult<>(entities));
    }
}
