package ru.yandex.direct.core.entity.image.service;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.image.container.ImageFileFormat;
import ru.yandex.direct.dbschema.ppc.enums.BannerImagesFormatsImageType;

public class ImageConstants {
    public static final Set<BannerImagesFormatsImageType> TEXT_BANNER_IMAGE_FORMAT_TYPES =
            ImmutableSet.<BannerImagesFormatsImageType>builder()
                    .add(BannerImagesFormatsImageType.regular)
                    .add(BannerImagesFormatsImageType.small)
                    .add(BannerImagesFormatsImageType.wide)
                    .build();

    public static final Set<BannerImagesFormatsImageType> LOGO_EXTENDED_IMAGE_FORMAT_TYPES =
            ImmutableSet.<BannerImagesFormatsImageType>builder()
                    .add(BannerImagesFormatsImageType.regular)
                    .add(BannerImagesFormatsImageType.small)
                    .add(BannerImagesFormatsImageType.wide)
                    .add(BannerImagesFormatsImageType.logo)
                    .build();

    public static final Set<ImageSize> ALLOWED_SIZES_FOR_MCBANNER = ImmutableSet.<ImageSize>builder()
            .add(new ImageSize().withWidth(240).withHeight(400))
            .build();

    private static final Set<ImageSize> ALLOWED_RETINA_SIZES = ImmutableSet.<ImageSize>builder()
            .add(new ImageSize().withWidth(640).withHeight(100))
            .add(new ImageSize().withWidth(640).withHeight(200))
            .add(new ImageSize().withWidth(640).withHeight(960))
            .add(new ImageSize().withWidth(960).withHeight(640))
            .build();

    private static final Set<ImageSize> ALLOWED_RETINA_SIZES_ORIGINAL = ImmutableSet.<ImageSize>builder()
            .add(new ImageSize().withWidth(320).withHeight(50))
            .add(new ImageSize().withWidth(320).withHeight(100))
            .add(new ImageSize().withWidth(320).withHeight(480))
            .add(new ImageSize().withWidth(480).withHeight(320))
            .build();

    public static final Set<ImageSize> ALLOWED_SIZES_FOR_AD_IMAGE = ImmutableSet.<ImageSize>builder()
            .add(new ImageSize().withWidth(240).withHeight(400))
            .add(new ImageSize().withWidth(728).withHeight(90))
            .add(new ImageSize().withWidth(516).withHeight(272))
            .add(new ImageSize().withWidth(300).withHeight(250))
            .add(new ImageSize().withWidth(300).withHeight(600))
            .add(new ImageSize().withWidth(336).withHeight(280))
            .add(new ImageSize().withWidth(300).withHeight(500))
            .add(new ImageSize().withWidth(970).withHeight(250))
            .addAll(ALLOWED_RETINA_SIZES)
            .build();

    public static final Set<ImageSize> ALLOWED_SIZES_FOR_AD_IMAGE_ORIGINAL = ImmutableSet.<ImageSize>builder()
            .add(new ImageSize().withWidth(240).withHeight(400))
            .add(new ImageSize().withWidth(728).withHeight(90))
            .add(new ImageSize().withWidth(516).withHeight(272))
            .add(new ImageSize().withWidth(300).withHeight(250))
            .add(new ImageSize().withWidth(300).withHeight(600))
            .add(new ImageSize().withWidth(336).withHeight(280))
            .add(new ImageSize().withWidth(300).withHeight(500))
            .add(new ImageSize().withWidth(970).withHeight(250))
            .addAll(ALLOWED_RETINA_SIZES_ORIGINAL)
            .build();

    public static final Set<String> SUPPORTED_SMALL_FORMATS = ImmutableSet.<String>builder()
            .add("x90")
            .add("y90")
            .add("x80")
            .add("y80")
            .add("y65")
            .add("y110")
            .add("y129")
            .add("y150")
            .add("x150")
            .build();

    public static final Set<String> SUPPORTED_REGULAR_FORMATS = ImmutableSet.<String>builder()
            .add("x90")
            .add("y90")
            .add("x80")
            .add("y80")
            .add("y65")
            .add("y110")
            .add("y129")
            .add("y150")
            .add("x150")
            .add("y180")
            .add("y160")
            .add("x180")
            .add("x160")
            .add("y300")
            .add("x300")
            .add("x320")
            .add("y320")
            .add("x378")
            .add("x360")
            .add("y360")
            .add("x410")
            .add("x450")
            .add("y450")
            .add("x600")
            .add("y600")
            .add("y680")
            .add("x756")
            .add("x820")
            .add("x900")
            .add("y900")
            .add("x1200")
            .build();

    public static final Set<String> SUPPORTED_WIDE_FORMATS = ImmutableSet.<String>builder()
            .add("wx1080")
            .add("wy300")
            .add("wy150")
            .add("wx150")
            .add("wx600")
            .add("wx300")
            .build();

    public static final Set<String> SUPPORTED_IMAGE_AD_FORMATS = ImmutableSet.<String>builder()
            .add("orig")
            .build();

    public static final Set<String> SUPPORTED_LOGO_FORMATS = ImmutableSet.<String>builder()
            .add("orig")
            .add("x90")
            .add("y90")
            .add("x80")
            .add("y80")
            .add("y65")
            .add("y110")
            .add("y129")
            .build();

    public static final Map<ImageType, Set<String>> SUPPORTED_FORMATS_BY_IMAGE_TYPE =
            ImmutableMap.<ImageType, Set<String>>builder()
                    .put(ImageType.SMALL, SUPPORTED_SMALL_FORMATS)
                    .put(ImageType.REGULAR, SUPPORTED_REGULAR_FORMATS)
                    .put(ImageType.WIDE, SUPPORTED_WIDE_FORMATS)
                    .put(ImageType.IMAGE_AD, SUPPORTED_IMAGE_AD_FORMATS)
                    .put(ImageType.LOGO, SUPPORTED_LOGO_FORMATS)
                    .build();

    public static final int MAX_IMAGE_NAME_SIZE = 255;

    public static final int MAX_IMAGES_PER_REQUEST_FOR_IMAGE_AD = 50;
    public static final int MAX_IMAGES_PER_REQUEST_FOR_MCBANNER = 50;
    public static final int MAX_IMAGES_PER_REQUEST_FOR_TEXT_AD = 1;
    public static final int MAX_IMAGES_PER_REQUEST_FOR_LOGO = 1;
    public static final int MAX_IMAGES_PER_REQUEST_FOR_MULTICARD = 10;
    public static final int MAX_IMAGES_PER_REQUEST_FOR_OFFER_IMAGE = 5;

    public static final int MAX_IMAGE_LINEAR_SIZE_IN_PIXEL = 5_000;

    public static final int MAX_IMAGE_FILE_SIZE_FOR_TEXT_BANNER = 1024 * 1024 * 10;
    public static final int MAX_IMAGE_FILE_SIZE_FOR_TEXT_IMAGE_BANNER = 1024 * 120;
    public static final int NEW_MAX_IMAGE_FILE_SIZE_FOR_TEXT_IMAGE_BANNER = 1024 * 512;
    public static final int MAX_IMAGE_FILE_SIZE_FOR_MC_BANNER = 1024 * 120;
    // для внутренней рекламы, могут использовать большие гифки
    public static final int MAX_IMAGE_FILE_SIZE_FOR_INTERNAL_BANNER = 1024 * 1024 * 10;
    public static final int MAX_IMAGE_FILE_SIZE_FOR_LOGO = 1024 * 1024 * 10;
    public static final int MAX_IMAGE_FILE_SIZE_FOR_MULTICARD = MAX_IMAGE_FILE_SIZE_FOR_TEXT_BANNER;
    public static final int MAX_IMAGE_FILE_SIZE_FOR_OFFER_IMAGE = 1024 * 1024 * 10;

    public static final String ORIG = "orig";

    public static final double BANNER_IMAGE_RATIO = 4.0 / 3;
    public static final double BANNER_IMAGE_WIDE_RATIO = 16.0 / 9;

    public static final int BANNER_IMAGE_WIDE_MIN_WIDTH_SIZE = 1080;
    public static final int BANNER_REGULAR_IMAGE_MIN_SIZE = 450;
    public static final int BANNER_SMALL_IMAGE_MIN_SIZE = 150;

    public static final double ACCURACY = 0.51;

    public static final String GIF_MIME_TYPE = "image/gif";
    public static final String JPG_MIME_TYPE = "image/jpeg";
    public static final String PNG_MIME_TYPE = "image/png";
    public static final String SVG_MIME_TYPE = "image/svg+xml";

    private static final Set<String> ALL_SUPPORTED_IMAGE_MIME_TYPES = StreamEx.of(ImageFileFormat.values())
            .map(ImageFileFormat::getTypedValue)
            .toImmutableSet();

    public static boolean isSupportedImageMimeType(String mimeType) {
        return ALL_SUPPORTED_IMAGE_MIME_TYPES.contains(mimeType);
    }

    private static final String LAST_URL_SEGMENT_REGEX = "([^/]+)/?$";
    public static final Pattern LAST_URL_SEGMENT_PATTERN = Pattern.compile(LAST_URL_SEGMENT_REGEX);

    private static final String AVATAR_NAMESPACE_PREFIX = "get-";
    public static final String AVATAR_NAMESPACE_PREFIX_REGEX = "^/" + AVATAR_NAMESPACE_PREFIX;

    public static final int MIN_LOGO_SIZE = 80;
    public static final int MIN_LOGO_EXTENDED_SIZE = 10;
    public static final int MAX_LOGO_EXTENDED_SIZE = 800;
}
