package ru.yandex.direct.core.entity.image.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntFunction;

import javax.annotation.Nonnull;

import ru.yandex.direct.core.entity.image.model.ImageMdsMeta;
import ru.yandex.direct.core.entity.image.model.ImageSizeMeta;
import ru.yandex.direct.core.entity.image.model.ImageSmartCenter;

public class SmartCenterUtils {
    private SmartCenterUtils() {
    }

    /**
     * Записывает измененные смарт-центры в overriddenSmartCenters
     */
    public static void overrideSmartCenters(@Nonnull ImageMdsMeta overriddenMdsMeta,
                                            Set<String> supportedFormats,
                                            ImageMdsMeta mdsMeta, int x, int y,
                                            String size, String ratio) {
        ImageMdsMeta updatedMdsMeta = new ImageMdsMeta().withSizes(mdsMeta.getSizes());
        ImageSizeMeta referenceSizeMeta = updatedMdsMeta.getSizes().get(size);
        // будем вычислять scale для масштабирования по большей стороне
        ToIntFunction<ImageSizeMeta> majorSizeExtractor;
        if (referenceSizeMeta.getWidth() > referenceSizeMeta.getHeight()) {
            majorSizeExtractor = ImageSizeMeta::getWidth;
        } else {
            majorSizeExtractor = ImageSizeMeta::getHeight;
        }
        int baseImgSize = majorSizeExtractor.applyAsInt(referenceSizeMeta);

        Map<String, ImageSizeMeta> sizes = updatedMdsMeta.getSizes();
        for (Map.Entry<String, ImageSizeMeta> e : sizes.entrySet()) {
            String s = e.getKey();
            if (!supportedFormats.contains(s)) {
                continue;
            }
            ImageSizeMeta sizeMeta = e.getValue();
            double scale = 1.0 * majorSizeExtractor.applyAsInt(sizeMeta) / baseImgSize;
            // меняем координаты inplace
            ImageSmartCenter center = sizeMeta.getSmartCenters().get(ratio);
            center.setX((int) Math.round(x * scale));
            center.setY((int) Math.round(y * scale));

            Map<String, ImageSizeMeta> overriddenSizes = overriddenMdsMeta.getSizes();
            overriddenSizes.computeIfAbsent(s, k -> new ImageSizeMeta().withSmartCenters(new HashMap<>()));

            Map<String, ImageSmartCenter> overriddenSmartCenters = overriddenSizes.get(s).getSmartCenters();
            overriddenSmartCenters.put(ratio, center);
        }
    }
}
