package ru.yandex.direct.core.entity.image.service.validation;

import java.util.Set;

import com.google.common.base.Objects;

import ru.yandex.direct.core.entity.image.container.ImageFileFormat;
import ru.yandex.direct.validation.result.DefectId;

public class ImageDefectIds {
    public enum Gen implements DefectId<Void> {
        IMAGE_CONTAINS_ANIMATION,
        IMAGE_MIME_TYPE_IS_NOT_SUPPORTED,
        IMAGE_SIZE_IS_NOT_ALLOWED,
        IMAGE_SIZE_IS_NOT_ALLOWED_MC_BANNER,
        INVALID_IMAGE_FILE,
        INVALID_IMAGE_URL,
        IMAGE_FILE_SIZE_GREATER_THAN_MAX
    }


    public enum SizesDefects implements DefectId<ImageMaxLinearSizeParam> {
        IMAGE_SIZES_GREATER_THAN_MAX
    }

    public enum Format implements DefectId<ImageFileFormatParam> {
        IMAGE_FILE_FORMAT_NOT_ALLOWED
    }

    public static class ImageMaxLinearSizeParam {
        private final Integer maxLinearSize;

        ImageMaxLinearSizeParam(Integer maxLinearSize) {
            this.maxLinearSize = maxLinearSize;
        }

        public Integer getMaxLinearSize() {
            return maxLinearSize;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ImageMaxLinearSizeParam that = (ImageMaxLinearSizeParam) o;
            return Objects.equal(maxLinearSize, that.maxLinearSize);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(maxLinearSize);
        }
    }

    public static class ImageFileFormatParam {
        private final Set<ImageFileFormat> allowedFormats;

        public ImageFileFormatParam(Set<ImageFileFormat> allowedFormats) {
            this.allowedFormats = allowedFormats;
        }

        public Set<ImageFileFormat> getAllowedFormats() {
            return allowedFormats;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            ImageFileFormatParam that = (ImageFileFormatParam) o;
            return allowedFormats.equals(that.allowedFormats);
        }

        @Override
        public int hashCode() {
            return java.util.Objects.hash(allowedFormats);
        }

        @Override
        public String toString() {
            return "ImageFileFormatParam{" +
                    "allowedFormats=" + allowedFormats +
                    '}';
        }
    }
}
