package ru.yandex.direct.core.entity.image.service.validation;

import java.util.Set;

import ru.yandex.direct.core.entity.image.container.ImageFileFormat;
import ru.yandex.direct.validation.result.Defect;

public class ImageDefects {
    public static Defect<Void> imageContainsAnimation() {
        return new Defect<>(ImageDefectIds.Gen.IMAGE_CONTAINS_ANIMATION);
    }

    public static Defect<Void> imageMimeTypeIsNotSupported() {
        return new Defect<>(ImageDefectIds.Gen.IMAGE_MIME_TYPE_IS_NOT_SUPPORTED);
    }

    public static Defect imageSizesGreaterThanMax(Integer maxImageLinearSizeInPixel) {
        return new Defect<>(ImageDefectIds.SizesDefects.IMAGE_SIZES_GREATER_THAN_MAX,
                new ImageDefectIds.ImageMaxLinearSizeParam(maxImageLinearSizeInPixel));
    }

    public static Defect imageFileFormatIsNotAllowed(Set<ImageFileFormat> allowedFormats) {
        return new Defect<>(ImageDefectIds.Format.IMAGE_FILE_FORMAT_NOT_ALLOWED,
                new ImageDefectIds.ImageFileFormatParam(allowedFormats));
    }

    public static Defect<Void> imageSizeIsNotAllowed() {
        return new Defect<>(ImageDefectIds.Gen.IMAGE_SIZE_IS_NOT_ALLOWED);
    }

    public static Defect<Void> imageSizeIsNotAllowedMcBanner() {
        return new Defect<>(ImageDefectIds.Gen.IMAGE_SIZE_IS_NOT_ALLOWED_MC_BANNER);
    }

    public static Defect<Void> invalidImageFile() {
        return new Defect<>(ImageDefectIds.Gen.INVALID_IMAGE_FILE);
    }

    public static Defect<Void> invalidImageUrl() {
        return new Defect<>(ImageDefectIds.Gen.INVALID_IMAGE_URL);
    }

    public static Defect<Void> imageFileSizeGreaterThanMax() {
        return new Defect<>(ImageDefectIds.Gen.IMAGE_FILE_SIZE_GREATER_THAN_MAX);
    }

}
