package ru.yandex.direct.core.entity.image.service.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.image.service.ImageConstants.MAX_IMAGE_FILE_SIZE_FOR_TEXT_BANNER;
import static ru.yandex.direct.core.entity.image.service.validation.ImageConstraints.imageFileSizeIsValid;
import static ru.yandex.direct.core.entity.image.service.validation.ImageConstraints.imageUrlIsValid;
import static ru.yandex.direct.core.entity.image.service.validation.SaveImageValidationService.imageHasValidMimeType;

@Service
@ParametersAreNonnullByDefault
public class SaveImageFromUrlToMdsValidationService {
    /**
     * Строка переданная в качестве ссылки является ссылкой
     */
    public ValidationResult<String, Defect> preValidate(String imageUrl) {
        ItemValidationBuilder<String, Defect> vb = ItemValidationBuilder.of(imageUrl);

        vb.checkBy(imageUrlIsValid());

        return vb.getResult();
    }

    public void validate(ValidationResult<String, Defect> validationResult, byte[] imageData) {
        ItemValidationBuilder<String, Defect> vb = new ItemValidationBuilder<>(validationResult);
        vb.checkBy(imageHasValidMimeType(imageData))
                .check(imageFileSizeIsValid(imageData, MAX_IMAGE_FILE_SIZE_FOR_TEXT_BANNER), When.isValid());
    }
}
