package ru.yandex.direct.core.entity.image.service.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.image.service.validation.ImageConstraints.imageUrlIsValid;

@Service
@ParametersAreNonnullByDefault
public class SaveImageFromUrlValidationService {
    /**
     * Строка переданная в качестве ссылки является ссылкой и загрузка изображений доступна для типа баннера
     */
    public ValidationResult<String, Defect> validate(String imageUrl) {
        ItemValidationBuilder<String, Defect> vb = ItemValidationBuilder.of(imageUrl);

        vb
                .checkBy(imageUrlIsValid());

        return vb.getResult();
    }
}
