package ru.yandex.direct.core.entity.image.service.validation.type;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.image.container.BannerImageType;
import ru.yandex.direct.core.entity.image.container.ImageMetaInformation;
import ru.yandex.direct.core.entity.image.model.ImageValidationContainer;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@ParametersAreNonnullByDefault
public interface ImageSaveValidationSupport {
    /**
     * Тип картинки
     */
    BannerImageType getBannerImageType();

    ValidationResult<List<Integer>, Defect> validate(List<ImageMetaInformation> imageMetaInformationList,
                                                     ValidationResult<List<Integer>, Defect> vr,
                                                     Map<Integer, Integer> imageIdToIndexOfFetchedImage);

    <T> ValidationResult<T, Defect> validateImageMetaInformation(T value, ImageMetaInformation imageMetaInformation);

    /**
     * Валидация картинки после получения данных из аватарницы и перед сохранением мета информации в БД.
     *
     * @param <T>
     * @param value
     * @param validationContainer
     * @return
     */
    default <T> ValidationResult<T, Defect> validateBeforeSave(T value, ImageValidationContainer validationContainer) {
        return ValidationResult.success(value);
    }
}
