package ru.yandex.direct.core.entity.image.service.validation.type;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Maps;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.image.container.BannerImageType;
import ru.yandex.direct.core.entity.image.container.ImageMetaInformation;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;

@Component
@ParametersAreNonnullByDefault
public class ImageSaveValidationSupportFacade {
    private final Map<BannerImageType, ImageSaveValidationSupport> supportMap;

    public ImageSaveValidationSupportFacade(List<ImageSaveValidationSupport> addOperationSupportList) {
        this.supportMap = Maps.uniqueIndex(addOperationSupportList, ImageSaveValidationSupport::getBannerImageType);
    }

    public ValidationResult<List<Integer>, Defect> validate(
            ValidationResult<List<Integer>, Defect> vr,
            Map<Integer, Integer> imageIdToIndexOfFetchedImage,
            BannerImageType bannerImageType,
            List<ImageMetaInformation> imageMetaInformationList) {
        ItemValidationBuilder<List<Integer>, Defect> itemValidationBuilder = new ItemValidationBuilder<>(vr);

        return getImageSaveSupport(bannerImageType)
                .validate(
                        imageMetaInformationList,
                        itemValidationBuilder.getResult(),
                        imageIdToIndexOfFetchedImage
                );
    }

    @SuppressWarnings("unchecked")
    public ImageSaveValidationSupport getImageSaveSupport(BannerImageType bannerImageType) {
        checkArgument(supportMap.containsKey(bannerImageType));
        return supportMap.get(bannerImageType);
    }
}
