package ru.yandex.direct.core.entity.internalads;

import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.internalads.model.MobileResourcesConfig;
import ru.yandex.direct.core.entity.moderation.model.AspectRatio;
import ru.yandex.direct.core.entity.moderation.model.InternalBannerRequestData;
import ru.yandex.direct.mail.EmailAddress;
import ru.yandex.direct.model.ModelProperty;

import static java.util.Map.entry;

public class Constants {
    // эти плейсы не хотят видеть потребители, потому что рекламу там не размещают,
    // а с ними в выпадающих списках в интерфейсе слишком много пунктов
    public static final Set<Long> INVALID_PLACES = Set.of(
            542L, 632L, 659L, 742L, 770L, 909L, 932L, 938L, 942L, 949L, 969L, 983L, 984L, 985L, 986L,
            987L, 988L, 989L, 990L, 991L, 992L, 996L, 1004L, 1005L, 1006L, 1007L, 1008L, 1009L, 1010L,
            1011L, 1013L, 1014L, 1015L, 1016L, 1017L, 1018L, 1019L, 1020L, 1021L, 1022L, 1026L, 1028L,
            1029L, 1030L, 1031L, 1032L, 1033L, 1034L, 1035L, 1036L, 1037L, 1038L, 1039L, 1040L, 1041L,
            1042L, 1043L, 1044L, 1045L, 1046L, 1047L, 1048L, 1049L, 1050L, 1051L, 1052L, 1053L, 1054L,
            1055L, 1078L, 1079L, 1080L, 1081L, 1082L, 1083L, 1090L, 1092L, 1093L, 1095L, 1096L, 1097L,
            1098L, 1099L, 1100L, 1101L, 1102L, 1103L, 1104L, 1105L, 1106L, 1107L, 1108L, 1111L, 1133L,
            1146L, 1153L, 1157L, 1159L, 1162L, 1168L, 1184L, 1187L, 1190L, 1542L, 1545L, 1546L, 1549L,
            1550L, 1552L, 1563L, 1568L, 1572L);

    // неактуальные шаблоны, которые не нужно показывать в интерфейсе
    public static final Set<Long> INVALID_TEMPLATES = Set.of(849L);

    // закодированные значения для ресурса Счетчик закрытия
    public static final String CLOSE_BY_CAMPAIGN_COUNTER_VALUE = "{CNTL}/0/{OCID}";
    public static final String CLOSE_BY_AD_GROUP_COUNTER_VALUE = "{CNTL}/0/{CID}";

    // соответствие id шаблонов к resourceId url и rating
    // для обновления рейтинга во внутренних баннерах мобильных приложений
    public static final Map<Long, MobileResourcesConfig> MOBILE_APP_TEMPLATE_IDS = Map.ofEntries(
            Map.entry(3103L, new MobileResourcesConfig(4059L, 4060L))
    );

    // допустимые спецсимволы для использования в текстовых ресурсах
    // длина спецсимволов, при расчете длины текста, считается как 1
    public static final Set<String> ALLOWED_SPEC_SYMBOLS_FOR_TEXT = Set.of("nbsp");

    // допустимые теги для использования в текстовых ресурсах
    // значения определяют длину спецсимвола, при расчете длины текста
    public static final Map<String, Integer> ALLOWED_TAGS_FOR_TEXT = Map.ofEntries(
            Map.entry("br", 1), Map.entry("strong", 0), Map.entry("/strong", 0),
            Map.entry("login", 0));

    // запрещенные последовательности символов, встречающиеся в текстовых ресурсах, если они не используются как
    // спецсимволы или теги
    public static final Set<String> ILLEGAL_SPEC_SYMBOLS_WITHOUT_BRACKETS = Set.of("nbsp");

    // суффикс в названии продукта, идентифицирующий его как реламирующий мобильные приложения
    public static final String APP_PRODUCT_SUFFIX = "-app";

    // модерируемые плейсы (плейсы, для которых требуется модерация баннеров)
    public static final Set<Long> MODERATED_PLACES = Set.of(1186L, 1167L, 1179L, 1182L, 1185L, 1628L, 1629L, 1631L,
            1603L, 1605L, 1645L, 1646L, 1647L);
    // шаблоны модерируемых плейсов
    // MediaBanner
    public static final Long MEDIA_BANNER_TEMPLATE_ID = 861L;
    // Тизер с текущим временем (только png, прозрачный)
    public static final Long TEASER_WITH_TIME_TEMPLATE_ID = 516L;
    // Тизер 2013 (json)
    public static final Long TEASER_TEMPLATE_ID = 631L;
    // Teaser_inline
    public static final Long TEASER_INLINE_TEMPLATE_ID = 866L;
    // Teaser_inline для прямого скачивания Браузера - морда
    public static final Long TEASER_INLINE_BROWSER_TEMPLATE_ID = 1001L;
    // Десктопный баннер на Морде (Internal)
    public static final Long DESKTOP_BANNER_ON_MORDA_TEMPLATE_ID = 3340L;
    // Баннер на 404
    public static final Long BANNER_ON_404_TEMPLATE_ID = 3343L;

    // Маппинг модерируемых шаблонов в запрос в Модерацию
    public static final Map<Long, Map<Long, ModelProperty<InternalBannerRequestData, String>>>
            MODERATED_TEMPLATES_RESOURCES_MAPPER = Map.ofEntries(
            entry(MEDIA_BANNER_TEMPLATE_ID, Map.ofEntries(
                    entry(3337L, InternalBannerRequestData.IMAGE),
                    entry(3338L, InternalBannerRequestData.IMAGE_ALT),
                    entry(3339L, InternalBannerRequestData.LINK))
            ),
            entry(TEASER_WITH_TIME_TEMPLATE_ID, Map.ofEntries(
                    entry(2333L, InternalBannerRequestData.LINK),
                    entry(2334L, InternalBannerRequestData.IMAGE),
                    entry(2335L, InternalBannerRequestData.TEXT1))
            ),
            entry(TEASER_TEMPLATE_ID, Map.ofEntries(
                    entry(3278L, InternalBannerRequestData.LINK),
                    entry(3279L, InternalBannerRequestData.IMAGE),
                    entry(3280L, InternalBannerRequestData.TITLE1),
                    entry(3281L, InternalBannerRequestData.TITLE2),
                    entry(3282L, InternalBannerRequestData.TEXT1),
                    entry(3283L, InternalBannerRequestData.TEXT2),
                    entry(3284L, InternalBannerRequestData.IMAGE_ALT),
                    entry(3741L, InternalBannerRequestData.PRIVACY_TEXT),
                    entry(3755L, InternalBannerRequestData.IMAGE_RETINA))
            ),
            entry(TEASER_INLINE_TEMPLATE_ID, Map.ofEntries(
                    entry(3342L, InternalBannerRequestData.LINK),
                    entry(3343L, InternalBannerRequestData.IMAGE),
                    entry(3344L, InternalBannerRequestData.TITLE1),
                    entry(3345L, InternalBannerRequestData.TITLE2),
                    entry(3346L, InternalBannerRequestData.TEXT1),
                    entry(3347L, InternalBannerRequestData.TEXT2),
                    entry(3348L, InternalBannerRequestData.IMAGE_ALT),
                    entry(3349L, InternalBannerRequestData.LINK_TYPE),
                    entry(3518L, InternalBannerRequestData.PRIVACY_TEXT),
                    entry(3756L, InternalBannerRequestData.IMAGE_RETINA))
            ),
            entry(TEASER_INLINE_BROWSER_TEMPLATE_ID, Map.ofEntries(
                    entry(3673L, InternalBannerRequestData.LINK),
                    entry(3674L, InternalBannerRequestData.IMAGE),
                    entry(3675L, InternalBannerRequestData.TITLE1),
                    entry(3676L, InternalBannerRequestData.TITLE2),
                    entry(3677L, InternalBannerRequestData.TEXT1),
                    entry(3678L, InternalBannerRequestData.TEXT2),
                    entry(3679L, InternalBannerRequestData.IMAGE_ALT),
                    entry(3680L, InternalBannerRequestData.LINK_TYPE),
                    entry(3683L, InternalBannerRequestData.PRIVACY_TEXT),
                    entry(4143L, InternalBannerRequestData.IMAGE_RETINA))
            ),
            entry(DESKTOP_BANNER_ON_MORDA_TEMPLATE_ID, Map.ofEntries(
                    entry(5247L, InternalBannerRequestData.IMAGE),
                    entry(5248L, InternalBannerRequestData.IMAGE_ALT),
                    entry(5249L, InternalBannerRequestData.IMAGE_RETINA),
                    entry(5250L, InternalBannerRequestData.LINK))
            ),
            entry(BANNER_ON_404_TEMPLATE_ID, Map.ofEntries(
                    entry(5730L, InternalBannerRequestData.IMAGE_ALT),
                    entry(5731L, InternalBannerRequestData.IMAGE),
                    entry(5732L, InternalBannerRequestData.LINK))
            )
    );

    // Связь картиночного поля с полем где отдаем дополнительную информацию (сейчас размеры картинок)
    public static final Map<ModelProperty<InternalBannerRequestData, String>,
            ModelProperty<InternalBannerRequestData, AspectRatio>> IMAGE_PROPERTY_TO_ASPECTS =
            Map.ofEntries(
                    entry(InternalBannerRequestData.IMAGE, InternalBannerRequestData.IMAGE_ASPECTS),
                    entry(InternalBannerRequestData.IMAGE_RETINA, InternalBannerRequestData.IMAGE_RETINA_ASPECTS)
            );

    public static boolean isImageProperty(ModelProperty<InternalBannerRequestData, String> property) {
        return IMAGE_PROPERTY_TO_ASPECTS.containsKey(property);
    }

    // ID модерируемых шаблонов
    public static final Set<Long> MODERATED_TEMPLATE_IDS = MODERATED_TEMPLATES_RESOURCES_MAPPER.keySet();

    public static boolean isModeratedTemplate(Long templateId) {
        return MODERATED_TEMPLATE_IDS.contains(templateId);
    }

    public static final String MAIL_PERSONAL = "direct-stopped-banners-notifications";

    public static final String NOTIFICATIONS_FROM_EMAIL = "direct_noreply@yandex-team.ru";
    public static final EmailAddress NOTIFICATIONS_EMAIL_ADDRESS_TO =
            new EmailAddress("banana-direct-alert@yandex-team.ru", null);

}
