package ru.yandex.direct.core.entity.internalads;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.model.TemplateVariable;
import ru.yandex.direct.core.entity.internalads.model.InternalAdsProduct;
import ru.yandex.direct.core.entity.internalads.model.InternalTemplateInfo;
import ru.yandex.direct.core.entity.internalads.model.ResourceInfo;
import ru.yandex.direct.core.entity.internalads.model.ResourceType;

import static ru.yandex.direct.core.entity.internalads.Constants.APP_PRODUCT_SUFFIX;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@ParametersAreNonnullByDefault
public class InternalAdValidationUtil {

    private InternalAdValidationUtil() {
    }

    public static List<Long> getBannerWithCloseCounterVarIds(List<InternalBanner> banners,
                                                             List<InternalTemplateInfo> templateInfoList,
                                                             String closeCounterValue) {
        var templateResourcesMapByTemplateId = StreamEx.of(templateInfoList)
                .mapToEntry(InternalTemplateInfo::getTemplateId, InternalTemplateInfo::getResources)
                .mapValues(resourceInfos -> listToMap(resourceInfos, ResourceInfo::getId))
                .toMap();

        return StreamEx.of(banners)
                .mapToEntry(InternalBanner::getTemplateVariables)
                .filterKeyValue((banner, vars) -> hasCloseCounterVariableWithValue(vars,
                        templateResourcesMapByTemplateId.get(banner.getTemplateId()), closeCounterValue))
                .keys()
                .map(InternalBanner::getId)
                .toList();
    }

    /**
     * Проверяет есть ли переменная с типом {@link ResourceType#CLOSE_COUNTER} и со значением closeCounterValue
     *
     * @param closeCounterValue передается {@link Constants#CLOSE_BY_CAMPAIGN_COUNTER_VALUE} или
     *                          {@link Constants#CLOSE_BY_AD_GROUP_COUNTER_VALUE}
     */
    private static boolean hasCloseCounterVariableWithValue(List<TemplateVariable> vars,
                                                            Map<Long, ResourceInfo> resourceInfoById,
                                                            String closeCounterValue) {
        return StreamEx.of(vars)
                .mapToEntry(var -> resourceInfoById.get(var.getTemplateResourceId()))
                .filterValues(Objects::nonNull)
                .filterValues(resourceInfo -> resourceInfo.getType() == ResourceType.CLOSE_COUNTER)
                .mapKeys(TemplateVariable::getInternalValue)
                .filterKeys(closeCounterValue::equals)
                .findFirst().isPresent();
    }

    /**
     * Проверяет, что в продукте размещается реклама мобильных приложений
     */
    public static boolean isMobileProduct(@Nullable InternalAdsProduct product) {
        return product != null && product.getName().contains(APP_PRODUCT_SUFFIX);
    }

}
