package ru.yandex.direct.core.entity.internalads.model;

import java.util.Objects;

/**
 * DirectTemplateResource с дополнительными полями
 */
public class DirectTemplateResourceWrapper implements ReadOnlyDirectTemplateResource {
    private String description;
    private Long position;
    private Long resourceType;
    private DirectTemplateResource resource;

    public boolean isRequired() {
        return resource.getOptions().contains(DirectTemplateResourceOption.REQUIRED);
    }

    public boolean isBananaUrl() {
        return resource.getOptions().contains(DirectTemplateResourceOption.BANANA_URL);
    }

    public boolean isBananaImage() {
        return resource.getOptions().contains(DirectTemplateResourceOption.BANANA_IMAGE);
    }

    public Long getId() {
        return resource.getDirectTemplateResourceId();
    }

    public Long getTemplateId() {
        return resource.getDirectTemplateId();
    }

    public Long getResourceNo() {
        return resource.getResourceNo();
    }

    public DirectTemplateResource getResource() {
        return resource;
    }

    public DirectTemplateResourceWrapper withResource(DirectTemplateResource resource) {
        this.resource = resource;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public DirectTemplateResourceWrapper withDescription(String description) {
        this.description = description;
        return this;
    }

    public Long getPosition() {
        return position;
    }

    public DirectTemplateResourceWrapper withPosition(Long position) {
        this.position = position;
        return this;
    }

    public Long getResourceType() {
        return resourceType;
    }

    public DirectTemplateResourceWrapper withResourceType(Long resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DirectTemplateResourceWrapper that = (DirectTemplateResourceWrapper) o;
        return Objects.equals(description, that.description) && Objects.equals(position, that.position)
                && Objects.equals(resourceType, that.resourceType) && Objects.equals(resource, that.resource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, position, resourceType, resource);
    }
}
