package ru.yandex.direct.core.entity.internalads.model;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import static ru.yandex.direct.core.entity.internalads.Constants.MODERATED_PLACES;

@ParametersAreNonnullByDefault
public class InternalAdPlaceInfo {
    private final Long id;
    private final String fullDescription;

    public InternalAdPlaceInfo(Long id, String fullDescription) {
        this.id = id;
        this.fullDescription = fullDescription;
    }

    public Long getId() {
        return id;
    }

    public String getFullDescription() {
        return fullDescription;
    }

    public boolean isModerated() {
        return MODERATED_PLACES.contains(id);
    }

    @Override
    public String toString() {
        return "InternalAdPlaceInfo{" +
                "id=" + id +
                ", fullDescription='" + fullDescription + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InternalAdPlaceInfo that = (InternalAdPlaceInfo) o;
        return id.equals(that.id) &&
                fullDescription.equals(that.fullDescription);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, fullDescription);
    }
}
