package ru.yandex.direct.core.entity.internalads.model;

import java.util.Set;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public class InternalAdsFullProductAccess implements InternalAdsOperatorProductAccess {
    private final Long operatorUid;
    private final ClientId productClientId;
    private final Supplier<Set<Long>> producerOfPlaceIds;

    public InternalAdsFullProductAccess(Long operatorUid, ClientId productClientId,
                                        Supplier<Set<Long>> producerOfPlaceIds) {
        this.operatorUid = operatorUid;
        this.productClientId = productClientId;
        this.producerOfPlaceIds = producerOfPlaceIds;
    }

    @Override
    public Long operatorUid() {
        return operatorUid;
    }

    @Override
    public ClientId productClientId() {
        return productClientId;
    }

    @Override
    public boolean hasReadAccess() {
        return true;
    }

    @Override
    public boolean hasWriteAccessToAnyPlace() {
        return true;
    }

    @Override
    public Set<Long> placesWithWriteAccess() {
        return producerOfPlaceIds.get();
    }

}
