package ru.yandex.direct.core.entity.internalads.model;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class InternalAdsManagerProductAccess {
    private final ClientId managerClientId;
    private final ClientId productClientId;
    private final InternalAdsManagerProductAccessType accessType;
    @Nullable
    private final Set<Long> placeIds;

    public InternalAdsManagerProductAccess(ClientId managerClientId, ClientId productClientId,
                                           InternalAdsManagerProductAccessType accessType,
                                           @Nullable Set<Long> placeIds) {
        this.managerClientId = managerClientId;
        this.productClientId = productClientId;

        if (accessType == InternalAdsManagerProductAccessType.FULL ||
                accessType == InternalAdsManagerProductAccessType.READONLY) {
            checkState(placeIds == null, "FULL or READONLY access requires a null set of placeIds");
        } else {
            checkState(placeIds != null, "PARTIAL access requires a non-null set of placeIds");
        }
        this.accessType = accessType;
        this.placeIds = placeIds;
    }

    public ClientId getManagerClientId() {
        return managerClientId;
    }

    public ClientId getProductClientId() {
        return productClientId;
    }

    public InternalAdsManagerProductAccessType getAccessType() {
        return accessType;
    }

    @Nullable
    public Set<Long> getPlaceIds() {
        return placeIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ClientId managerClientId;
        private ClientId productClientId;
        private InternalAdsManagerProductAccessType accessType;
        @Nullable
        private Set<Long> placeIds;

        public Builder withManagerClientId(ClientId managerClientId) {
            this.managerClientId = managerClientId;
            return this;
        }

        public Builder withProductClientId(ClientId productClientId) {
            this.productClientId = productClientId;
            return this;
        }

        public Builder withAccessType(InternalAdsManagerProductAccessType accessType) {
            this.accessType = accessType;
            return this;
        }

        public Builder withPlaceIds(@Nullable Set<Long> placeIds) {
            this.placeIds = placeIds;
            return this;
        }

        public InternalAdsManagerProductAccess build() {
            return new InternalAdsManagerProductAccess(managerClientId, productClientId, accessType, placeIds);
        }
    }
}
