package ru.yandex.direct.core.entity.internalads.model;

import java.util.Collections;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public class InternalAdsNoProductAccess implements InternalAdsOperatorProductAccess {
    private final Long operatorUid;
    private final ClientId productClientId;

    public InternalAdsNoProductAccess(Long operatorUid, ClientId productClientId) {
        this.operatorUid = operatorUid;
        this.productClientId = productClientId;
    }

    @Override
    public Long operatorUid() {
        return operatorUid;
    }

    @Override
    public ClientId productClientId() {
        return productClientId;
    }

    @Override
    public boolean hasReadAccess() {
        return false;
    }

    @Override
    public boolean hasWriteAccessToAnyPlace() {
        return false;
    }

    @Override
    public Set<Long> placesWithWriteAccess() {
        return Collections.emptySet();
    }
}
