package ru.yandex.direct.core.entity.internalads.model;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

/**
 * какой доступ есть у оператора к продукту внутренней рекламы, включая доступ по плейсам
 * такой интерфейс (и реализации) нужны, чтобы реальные права вычислялись в одном месте,
 * а не проверялись в зависимости от роли и типа связи в clients_relations в нескольких
 * местах
 */
@ParametersAreNonnullByDefault
public interface InternalAdsOperatorProductAccess {
    Long operatorUid();
    ClientId productClientId();

    /**
     * есть ли доступ на чтение; на момент написания, если есть доступ на чтение,
     * он не зависит от плейсов, можно читать и смотреть статистику всех кампаний
     * в продукте
     */
    boolean hasReadAccess();

    /**
     * может ли оператор управлять кампаниями с любыми плейсами, в том числе с плейсами,
     * про которых Директу почему-то неизвестно
     */
    boolean hasWriteAccessToAnyPlace();

    /**
     * к кампаниям с какими плейсами есть доступ у оператора; если у оператора есть
     * доступ к любым плейсам, этот метод вернёт все плейсы, про которые известно
     * Директу
     *
     * когда надо вызывать этот метод: когда надо показать выпадашку со списком плейсов
     * когда не надо вызывать этот метод: когда надо проверить, есть ли доступ к этому плейсу;
     * в таких случаях надо пользоваться соседним {@link InternalAdsOperatorProductAccess#hasWriteAccessToPlace}
     * @return
     */
    Set<Long> placesWithWriteAccess();

    /**
     * может ли оператор управлять в этом продукте кампаниями с этим плейсом
     * от реализаций интерфейса не ожидается перегрузки этого метода,
     * default-реализация всё должна делать правильно
     */
    default boolean hasWriteAccessToPlace(Long placeId) {
        return hasWriteAccessToAnyPlace() || placesWithWriteAccess().contains(placeId);
    }
}
