package ru.yandex.direct.core.entity.internalads.model;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.dbutil.model.ClientId;

@ParametersAreNonnullByDefault
public class InternalAdsPartialProductAccess implements InternalAdsOperatorProductAccess {
    private final Long operatorUid;
    private final ClientId productClientId;
    private final Set<Long> placeIds;

    public InternalAdsPartialProductAccess(Long operatorUid, ClientId productClientId, Set<Long> placeIds) {
        this.operatorUid = operatorUid;
        this.productClientId = productClientId;
        this.placeIds = placeIds;
    }

    @Override
    public Long operatorUid() {
        return operatorUid;
    }

    @Override
    public ClientId productClientId() {
        return productClientId;
    }

    @Override
    public boolean hasReadAccess() {
        return true;
    }

    @Override
    public boolean hasWriteAccessToAnyPlace() {
        return false;
    }

    @Override
    public Set<Long> placesWithWriteAccess() {
        return placeIds;
    }
}
