package ru.yandex.direct.core.entity.internalads.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.client.model.ClientWithUsers;

@ParametersAreNonnullByDefault
public class InternalAdsProductWithClient {
    private final InternalAdsProduct product;
    private final ClientWithUsers client;

    private InternalAdsProductWithClient(InternalAdsProduct product, ClientWithUsers client) {
        this.product = product;
        this.client = client;
    }

    public static InternalAdsProductWithClient of(InternalAdsProduct product, ClientWithUsers client) {
        return new InternalAdsProductWithClient(product, client);
    }

    public InternalAdsProduct getProduct() {
        return product;
    }

    public ClientWithUsers getClient() {
        return client;
    }
}
