package ru.yandex.direct.core.entity.internalads.model;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.client.model.ClientWithUsers;

@ParametersAreNonnullByDefault
public class InternalAdsProductWithClientAndAccess {
    private final InternalAdsProduct product;
    private final ClientWithUsers client;
    private final InternalAdsManagerProductAccess access;

    private InternalAdsProductWithClientAndAccess(InternalAdsProduct product, ClientWithUsers client,
                                                  InternalAdsManagerProductAccess access) {
        this.product = product;
        this.client = client;
        this.access = access;
    }

    public static InternalAdsProductWithClientAndAccess of(InternalAdsProduct product, ClientWithUsers client,
                                                           InternalAdsManagerProductAccess access) {
        return new InternalAdsProductWithClientAndAccess(product, client, access);
    }

    public InternalAdsProduct getProduct() {
        return product;
    }

    public ClientWithUsers getClient() {
        return client;
    }

    public InternalAdsManagerProductAccess getAccess() {
        return access;
    }
}
