package ru.yandex.direct.core.entity.internalads.model;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InternalTemplateInfo {

    private Long templateId;
    private List<ResourceInfo> resources;
    private List<ResourceRestriction> resourceRestrictions;
    private String resourceRestrictionsErrorMessage;

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public InternalTemplateInfo withTemplateId(Long templateId) {
        setTemplateId(templateId);
        return this;
    }

    public List<ResourceInfo> getResources() {
        return resources;
    }

    public void setResources(List<ResourceInfo> resources) {
        this.resources = resources;
    }

    public InternalTemplateInfo withResources(List<ResourceInfo> resources) {
        setResources(resources);
        return this;
    }

    /**
     * Варианты ограничений -- должно выполниться хотябы одно
     */
    public List<ResourceRestriction> getResourceRestrictions() {
        return resourceRestrictions;
    }

    public void setResourceRestrictions(List<ResourceRestriction> resourceRestrictions) {
        this.resourceRestrictions = resourceRestrictions;
    }

    public InternalTemplateInfo withResourceRestrictions(
            List<ResourceRestriction> resourceRestrictions) {
        setResourceRestrictions(resourceRestrictions);
        return this;
    }

    /**
     * Текст ошибки если не выполнились Варианты ограничений
     */
    public String getResourceRestrictionsErrorMessage() {
        return resourceRestrictionsErrorMessage;
    }

    public void setResourceRestrictionsErrorMessage(String resourceRestrictionsErrorMessage) {
        this.resourceRestrictionsErrorMessage = resourceRestrictionsErrorMessage;
    }

    public InternalTemplateInfo withResourceRestrictionsErrorMessage(String resourceRestrictionsErrorMessage) {
        this.resourceRestrictionsErrorMessage = resourceRestrictionsErrorMessage;
        return this;
    }

    @Override
    public String toString() {
        return "InternalTemplateInfo{" +
                "templateId=" + templateId +
                ", resources=" + resources +
                ", resourceRestrictions=" + resourceRestrictions +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InternalTemplateInfo that = (InternalTemplateInfo) o;
        return Objects.equals(templateId, that.templateId) &&
                Objects.equals(resources, that.resources) &&
                Objects.equals(resourceRestrictions, that.resourceRestrictions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(templateId, resources, resourceRestrictions);
    }
}
