package ru.yandex.direct.core.entity.internalads.model;

import java.util.regex.Pattern;

/**
 * С точки зрения чтения TemplateResource и DirectTemplateResourceWrapper почти одинаковые
 */
public interface ReadOnlyDirectTemplateResource {

    Pattern CLOSE_COUNTER_DESCRIPTIONS_PATTERN = Pattern.compile("Сч[её]тчик закрытия");

    boolean isRequired();

    boolean isBananaUrl();

    boolean isBananaImage();

    default boolean isAgeLabel() {
        return getDescription().startsWith("Возрастн");
    }

    default boolean isCloseCounter() {
        return CLOSE_COUNTER_DESCRIPTIONS_PATTERN.matcher(getDescription()).matches();
    }

    Long getId();

    Long getTemplateId();

    Long getResourceNo();

    String getDescription();

    Long getPosition();

    Long getResourceType();
}
