package ru.yandex.direct.core.entity.internalads.model;

import java.util.List;

import ru.yandex.direct.core.entity.internalads.restriction.Restriction;

public class ResourceInfo extends AbstractResourceInfo {
    private List<Restriction> valueRestrictions;
    private boolean hidden = false;

    public List<Restriction> getValueRestrictions() {
        return valueRestrictions;
    }

    public void setValueRestrictions(List<Restriction> valueRestrictions) {
        this.valueRestrictions = valueRestrictions;
    }

    public ResourceInfo withValueRestrictions(List<Restriction> valueRestrictions) {
        setValueRestrictions(valueRestrictions);
        return this;
    }

    public Boolean isHidden() {
        return hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public ResourceInfo withHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public ResourceInfo withId(Long id) {
        super.withId(id);
        return this;
    }

    @Override
    public ResourceInfo withNo(Long no) {
        super.withNo(no);
        return this;
    }

    @Override
    public ResourceInfo withPosition(Long position) {
        setPosition(position);
        return this;
    }

    @Override
    public ResourceInfo withLabel(String label) {
        super.withLabel(label);
        return this;
    }

    @Override
    public ResourceInfo withType(ResourceType type) {
        super.withType(type);
        return this;
    }

    @Override
    public ResourceInfo withChoices(List<ResourceChoice> choices) {
        super.setChoices(choices);
        return this;
    }
}
