package ru.yandex.direct.core.entity.internalads.model;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Модель представления ресурсов (переменных), необходимых для шаблона templateId https://wiki.yandex-team.ru/andreysagulin/tables/#templateresource
 * Дополняет {@link AbstractTemplateResource} геттерами для удобного получения опций
 *
 * @deprecated будущее за {@link DirectTemplateResourceWrapper}, при необходимости правок в этом классе, стоит подумать
 * про общее место
 */
@Deprecated
@ParametersAreNonnullByDefault
public class TemplateResource extends AbstractTemplateResource implements ReadOnlyDirectTemplateResource {

    //getters for option
    public boolean isRequired() {
        return getOptions().contains(TemplateResourceOption.REQUIRED);
    }

    public boolean isBananaUrl() {
        return getOptions().contains(TemplateResourceOption.BANANA_URL);
    }

    public boolean isBananaImage() {
        return getOptions().contains(TemplateResourceOption.BANANA_IMAGE);
    }

    //extended with-setters
    @Override
    public TemplateResource withId(Long id) {
        setId(id);
        return this;
    }

    @Override
    public TemplateResource withTemplateId(Long templateId) {
        setTemplateId(templateId);
        return this;
    }

    @Override
    public TemplateResource withResourceNo(Long resourceNo) {
        setResourceNo(resourceNo);
        return this;
    }

    @Override
    public TemplateResource withTemplatePartNo(Long templatePartNo) {
        setTemplatePartNo(templatePartNo);
        return this;
    }

    @Override
    public TemplateResource withTemplateCounterType(Long templateCounterType) {
        setTemplateCounterType(templateCounterType);
        return this;
    }

    @Override
    public TemplateResource withDescription(String description) {
        setDescription(description);
        return this;
    }

    @Override
    public TemplateResource withResourceType(Long resourceType) {
        setResourceType(resourceType);
        return this;
    }

    @Override
    public TemplateResource withPosition(Long position) {
        setPosition(position);
        return this;
    }

    @Override
    public TemplateResource withOptions(Set<TemplateResourceOption> options) {
        setOptions(options);
        return this;
    }

}
